#ifdef _WIN32
#include "windows.h"
#endif

#include "stdio.h"
#include "math.h"
#include "stdlib.h"
#include "string.h"

#include "GL/gl.h"
#include "GL/glu.h"
#include "SDL.h"
#include "SDL_image.h"
#include "SDL_mixer.h"
#include "SDL_net.h"

#include "sound.h"
#include "List.h"
#include "2DCMC.h"
#include "auxiliar.h"
#include "GLTile.h"
#include "PlacedGLTile.h"
#include "RotatedGLTile.h"
#include "keyboardstate.h"
#include "CPlayer.h"
#include "CCar.h"
#include "2DCMC.h"
#include "RoadPiece.h"
#include "track.h"
#include "RacingCCar.h"
#include "PlayerCCar.h"
#include "EnemyCCar.h"
#include "GameParameters.h"
#include "ReplayInfo.h"
#include "F1SpiritGame.h"
#include "F1SpiritApp.h"
#include "F1Spirit-auxiliar.h"

#include "debug.h"

#ifdef KITSCHY_DEBUG_MEMORY 
#include "debug_memorymanager.h"
#endif

PlayerCCar::PlayerCCar() : RacingCCar()
{
	track=0;
	car=0;
	laps=0;
	camera_type=2;

	show_damage_timmer=0;
	show_damage_cycle=0;

	lap_time[0]=0;
	lap_time[1]=0;
	lap_time[2]=0;
	lap_time[3]=0;

	wrong_way=false;

	show_pit_stop=-1;
	pit_time=0;

	zoom_speed=2;

	last_sign_showing=-1;
	times_sign_showed=0;
} /* PlayerCCar::PlayerCCar */ 


PlayerCCar::~PlayerCCar()
{
	delete car;
	car=0;
} /* PlayerCCar::~PlayerCCar */ 

